<?php


class AopsEntriesCsvExport extends AopsEntryManager {

	private $cu_id = 0;
	private $orderby;
	private $order;
	private $separator = ',';
	private $newline = "\n";

	private $items = false;
	private $titles = array();

	function __construct() {
		parent::__construct();

		$this->cu_id = isset($_GET['cu_id']) ? intval($_GET['cu_id']) : 0;
		$this->orderby = 'id';
		if ( isset($_GET['orderby'])  && in_array($_GET['orderby'], array('id','name','email','created_at'))) {
			$this->orderby = $_GET['orderby'];
		}
		$this->order	= isset($_GET['order']) ? ($_GET['order'] === 'ASC' ? 'ASC' : 'DESC') : 'ASC';
	}


	/**
	 * Prepare the query with different parameters
	 */
	private function prepareItems() {
		global $wpdb;

		/* -- Preparing your query -- */
		if ($this->cu_id) {
			$select = "name, email, created_at ";
			$where = $wpdb->prepare(" cu_id = %d ", $this->cu_id);
		}
		else {
			$select = " * ";
			$where = " 1=1 ";
		}

		$query = "SELECT " . $select . " FROM " . $this->tableName . ' WHERE ' . $where;

		/* -- Ordering parameters -- */

		$query .= $wpdb->prepare(' ORDER BY "%s" "%s" ', $this->orderby, $this->order);

		/* -- Fetch the items -- */
		$this->items = $this->db->get_results($query);
	 }

	/**
	 * send headers
	 */
	private function echoHeaders() {

		$source = $this->cu_id > 0 ?  $this->cu_id : 'all';
		$date = date('Y-m-d');
		$fileName = 'content_upgrade_entries_' . $source. '_report_' . $date . '.csv';

		header("Pragma: public");
		header("Expires: 0");
		header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
		header("Cache-Control: private", false);
		header("Content-Type: application/octet-stream");
		header("Content-Disposition: attachment; filename=\"$fileName\";" );
		header("Content-Transfer-Encoding: binary");
	}

	private function generateCSV() {
		if (!$this->cu_id) {
			$csvOutput = 'First Name' . $this->separator
				. 'Email' . $this->separator
				. 'Content Upgrade' . $this->separator
				. 'Submitted' . $this->newline;
		}
		else {
			$csvOutput = 'First Name' . $this->separator
				. 'Email' . $this->separator
				. 'Submitted' . $this->newline;
		}

		foreach ($this->items as $item) {
			if ($this->cu_id) {
				$csvOutput .= $item->name . $this->separator
					. $item->email . $this->separator
					. $item->created_at;
			}
			else {
				$csvOutput .= $item->name . $this->separator
					. $item->email . $this->separator
					. $this->getTitle($item->cu_id) . $this->separator
					. $item->created_at;
			}
            $csvOutput .= $this->newline;
		}
		return $csvOutput;
	}

	public function generate() {
		$this->prepareItems();
		$csv = $this->generateCSV();
		$this->echoHeaders();
		echo $csv;
	}

	private function getTitle($cu_id) {
		if (!isset($this->titles[$cu_id])) {
			$this->titles[$cu_id] = get_the_title($cu_id);
		}
		return $this->titles[$cu_id];
	}
}

?>
